package com.company.model;

import com.company.exceptions.InvalidDataException;

public class Subject {
    private String initials;
    private String designation;

    private boolean isInitialsValid(String initials) {
        if (initials.length() < 4) {
            return false;
        }
        return true;
    }

    public Subject(String initials, String designation) {
        setInitials(initials);
        this.designation = designation;
    }

    public Subject(Subject obj) {
        setInitials(obj.initials);
        this.designation = obj.designation;
    }

    public String getInitials() {
        return initials;
    }

    public void setInitials(String initials) {
        if (isInitialsValid(initials)) {
            this.initials = initials;
        } else {

            String msg = "Instructor: " + initials;
            throw new InvalidDataException(msg);
        }
    }

    public String getDesignation() {
        return designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public boolean isEqualTo(Subject obj) {
        if (this.initials.equals(obj.initials)) {
            return true;
        }
        return false;
    }

    public boolean isEqualTo(String str) {
        if (this.initials.equals(str)) {
            return true;
        }
        return false;
    }
}
